// DO NOT EDIT THIS FILE.
use std::iter::zip;
use q3_lib::{tuple_zip, tuple_unzip};

#[derive(Debug, PartialEq, Eq)]
struct Number {
    num: u64,
    is_positive: bool
}

impl From<(u64, bool)> for Number {
    fn from(thing: (u64, bool)) -> Self {
        Self {
            num: thing.0,
            is_positive: thing.1
        }
    }
}

impl From<Number> for (u64, bool) {
    fn from(thing: Number) -> Self {
        (thing.num, thing.is_positive)
    }
}

fn main() {
    let nums = vec![
        Number {num: 2, is_positive: true}
        Number {num: 3, is_positive: false}
    ];

    let (xs, ys) = tuple_unzip(nums);

    assert_eq!(xs, vec![2, 3]);
    assert_eq!(ys, vec![true, false]);

    let nums: Vec<Number> = tuple_zip((xs, ys));

    assert_eq!(
        nums,
        vec![
            Number {num: 2, is_positive: true}
            Number {num: 3, is_positive: false}
        ]
    )
}
