/*
 * Decompiled with CFR 0.152.
 */
package lab2;

import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLCapabilities;
import com.jogamp.opengl.GLCapabilitiesImmutable;
import com.jogamp.opengl.GLEventListener;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.awt.GLJPanel;
import com.jogamp.opengl.util.FPSAnimator;
import java.awt.Component;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import lab2.DrawingController;
import lab2.DrawingModel;
import lab2.Mouse;

public class DrawingView
implements GLEventListener {
    private DrawingModel myModel;

    public DrawingView(DrawingModel model) {
        this.myModel = model;
    }

    public void init(GLAutoDrawable drawable) {
        GL2 gl = drawable.getGL().getGL2();
        gl.glClearColor(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void dispose(GLAutoDrawable drawable) {
    }

    public void display(GLAutoDrawable drawable) {
        List<Double> polygon2;
        GL2 gl = drawable.getGL().getGL2();
        Mouse.update(gl);
        gl.glClearColor(this.myModel.getBgColor()[0], this.myModel.getBgColor()[1], this.myModel.getBgColor()[2], 1.0f);
        gl.glClear(16384);
        gl.glColor3fv(this.myModel.getColor(), 0);
        for (List<Double> polygon2 : this.myModel.getPolygons()) {
            gl.glBegin(9);
            int i = 0;
            while (i < polygon2.size()) {
                double x = polygon2.get(i);
                double y = polygon2.get(i + 1);
                gl.glVertex2d(x, y);
                i += 2;
            }
            gl.glEnd();
        }
        polygon2 = this.myModel.getWorkingPolygon();
        gl.glBegin(3);
        int i = 0;
        while (i < polygon2.size()) {
            double x = polygon2.get(i);
            double y = polygon2.get(i + 1);
            gl.glVertex2d(x, y);
            i += 2;
        }
        if (!polygon2.isEmpty()) {
            double[] p = this.myModel.getMousePoint();
            gl.glVertex2d(p[0], p[1]);
        }
        gl.glEnd();
    }

    public void reshape(GLAutoDrawable drawable, int x, int y, int width, int height) {
    }

    private static void initMenu(JFrame f, DrawingController c) {
        JMenuBar menuBar = new JMenuBar();
        JMenu menu = new JMenu("Options");
        menuBar.add(menu);
        JMenuItem item = new JMenuItem("Foreground");
        menu.add(item);
        JMenuItem item2 = new JMenuItem("Background");
        menu.add(item2);
        item.addActionListener(c);
        item2.addActionListener(c);
        f.setJMenuBar(menuBar);
    }

    public static void main(String[] args) {
        GLProfile glp = GLProfile.getDefault();
        GLCapabilities caps = new GLCapabilities(glp);
        GLJPanel panel = new GLJPanel((GLCapabilitiesImmutable)caps);
        JFrame jframe = new JFrame("Drawing");
        jframe.setSize(800, 600);
        jframe.setDefaultCloseOperation(3);
        DrawingModel model = new DrawingModel();
        DrawingView view = new DrawingView(model);
        panel.addGLEventListener((GLEventListener)view);
        DrawingController controller = new DrawingController(model);
        panel.addMouseListener((MouseListener)controller);
        panel.addMouseMotionListener((MouseMotionListener)controller);
        panel.addMouseMotionListener((MouseMotionListener)Mouse.theMouse);
        DrawingView.initMenu(jframe, controller);
        jframe.add((Component)panel);
        jframe.setVisible(true);
        float[] scale = new float[2];
        panel.getCurrentSurfaceScale(scale);
        System.out.println(String.valueOf(scale[0]) + ", " + scale[1]);
        Mouse.setSurfaceScale(scale);
        FPSAnimator animator = new FPSAnimator(60);
        animator.add((GLAutoDrawable)panel);
        animator.start();
    }
}

