/*
 * Decompiled with CFR 0.152.
 */
package lab2;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;

public class DrawingModel {
    private List<List<Double>> myPolygons;
    private List<Double> myWorkingPoly;
    private double[] myMousePoint;
    private float[] myCol = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
    private float[] myBgCol = new float[]{1.0f, 1.0f, 1.0f, 1.0f};

    public DrawingModel() {
        this.myPolygons = new ArrayList<List<Double>>();
        this.myWorkingPoly = new ArrayList<Double>();
        this.myMousePoint = new double[2];
    }

    public void setColor(Color c) {
        this.myCol[0] = (float)c.getRed() / 255.0f;
        this.myCol[1] = (float)c.getGreen() / 255.0f;
        this.myCol[2] = (float)c.getBlue() / 255.0f;
    }

    public void setBackgroundColor(Color c) {
        this.myBgCol[0] = (float)c.getRed() / 255.0f;
        this.myBgCol[1] = (float)c.getGreen() / 255.0f;
        this.myBgCol[2] = (float)c.getBlue() / 255.0f;
    }

    public float[] getBgColor() {
        return this.myBgCol;
    }

    public float[] getColor() {
        return this.myCol;
    }

    public List<List<Double>> getPolygons() {
        return this.myPolygons;
    }

    public List<Double> getWorkingPolygon() {
        return this.myWorkingPoly;
    }

    public double[] getMousePoint() {
        return this.myMousePoint;
    }

    public void setMousePoint(double x, double y) {
        this.myMousePoint[0] = x;
        this.myMousePoint[1] = y;
    }

    public void addPoint(double x, double y) {
        this.myWorkingPoly.add(x);
        this.myWorkingPoly.add(y);
    }

    public void addPolygon() {
        this.myPolygons.add(this.myWorkingPoly);
        this.myWorkingPoly = new ArrayList<Double>();
    }
}

