/*
 * Decompiled with CFR 0.152.
 */
package lab2;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JColorChooser;
import lab2.DrawingModel;
import lab2.Mouse;

public class DrawingController
extends MouseAdapter
implements ActionListener {
    private DrawingModel myModel;

    public DrawingController(DrawingModel model) {
        this.myModel = model;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        double[] p = Mouse.getPosition();
        this.myModel.setMousePoint(p[0], p[1]);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        double[] p = Mouse.getPosition();
        this.myModel.setMousePoint(p[0], p[1]);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.getButton() == 1) {
            double[] p = Mouse.getPosition();
            this.myModel.addPoint(p[0], p[1]);
        } else if (e.getButton() == 3) {
            this.myModel.addPolygon();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Foreground")) {
            Color newColor = JColorChooser.showDialog(null, "Set Foreground", Color.black);
            this.myModel.setColor(newColor);
        } else {
            Color newColor = JColorChooser.showDialog(null, "Set Background", Color.black);
            this.myModel.setBackgroundColor(newColor);
        }
    }
}

