/*
 * Decompiled with CFR 0.152.
 */
package FlutteryPigeon;

import FlutteryPigeon.CircularGameObject;
import FlutteryPigeon.GameObject;
import com.jogamp.opengl.GL2;
import java.util.LinkedList;
import java.util.List;

public class SectorGameObject
extends CircularGameObject {
    private List<double[]> vertices;
    private double angle;
    private boolean drawMiddleLine;

    public SectorGameObject(GameObject gameObject, double[] dArray, double[] dArray2) {
        this(gameObject, dArray, dArray2, 180.0);
    }

    public SectorGameObject(GameObject gameObject, double[] dArray, double[] dArray2, double d) {
        this(gameObject, 1.0, dArray, dArray2, d);
    }

    public SectorGameObject(GameObject gameObject, double d, double[] dArray, double[] dArray2) {
        this(gameObject, d, dArray, dArray2, 180.0);
    }

    public SectorGameObject(GameObject gameObject, double d, double[] dArray, double[] dArray2, double d2) {
        this(gameObject, d, new double[]{0.0, 0.0}, dArray, dArray2, d2);
    }

    public SectorGameObject(GameObject gameObject, double d, double[] dArray, double[] dArray2, double[] dArray3) {
        this(gameObject, d, dArray, dArray2, dArray3, 180.0);
    }

    public SectorGameObject(GameObject gameObject, double d, double[] dArray, double[] dArray2, double[] dArray3, double d2) {
        super(gameObject, d, dArray, dArray2, dArray3);
        this.angle = d2;
        this.vertices = new LinkedList<double[]>();
        this.calculateVertexLocations();
        this.drawMiddleLine = true;
    }

    private void calculateVertexLocations() {
        double d = Math.PI * 2 * (this.angle / 360.0);
        for (int i = 0; i <= 32; ++i) {
            this.vertices.add(new double[]{this.getCentre()[0] + this.getRadius() * Math.cos((double)i * d / 32.0), this.getCentre()[1] + this.getRadius() * Math.sin((double)i * d / 32.0)});
        }
    }

    public boolean isDrawMiddleLine() {
        return this.drawMiddleLine;
    }

    public void setDrawMiddleLine(boolean bl) {
        this.drawMiddleLine = bl;
    }

    @Override
    public void drawSelf(GL2 gL2) {
        if (this.getFillColour() != null) {
            gL2.glBegin(6);
            gL2.glColor4dv(this.getFillColour(), 0);
            gL2.glVertex2dv(this.getCentre(), 0);
            for (double[] dArray : this.vertices) {
                gL2.glVertex2dv(dArray, 0);
            }
            gL2.glEnd();
        }
        if (this.getLineColour() != null) {
            if (this.drawMiddleLine) {
                gL2.glBegin(2);
                gL2.glColor4dv(this.getLineColour(), 0);
                gL2.glVertex2dv(this.getCentre(), 0);
                for (double[] dArray : this.vertices) {
                    gL2.glVertex2dv(dArray, 0);
                }
                gL2.glVertex2dv(this.getCentre(), 0);
                gL2.glEnd();
            } else {
                gL2.glBegin(3);
                gL2.glColor4dv(this.getLineColour(), 0);
                for (double[] dArray : this.vertices) {
                    gL2.glVertex2dv(dArray, 0);
                }
                gL2.glEnd();
            }
        }
    }
}

