/*
 * Decompiled with CFR 0.152.
 */
package FlutteryPigeon;

import FlutteryPigeon.Colours;
import FlutteryPigeon.GameObject;
import com.jogamp.opengl.GL2;
import java.util.LinkedList;
import java.util.List;

public class PoleObject
extends GameObject {
    private List<double[]> vertices;
    private double[] fillColour;
    private double[] lineColour;
    private boolean isTop;
    private double width;
    private double height;

    public PoleObject(GameObject gameObject, double d, double d2) {
        this(gameObject, d, d2, Colours.GREEN, Colours.BLACK);
    }

    public PoleObject(GameObject gameObject, double d, double d2, double[] dArray, double[] dArray2) {
        super(gameObject);
        this.fillColour = dArray;
        this.lineColour = dArray2;
        this.vertices = new LinkedList<double[]>();
        this.vertices.add(new double[]{0.0, 0.0});
        this.vertices.add(new double[]{d2, 0.0});
        this.vertices.add(new double[]{d2, d});
        this.vertices.add(new double[]{0.0, d});
        this.width = d2;
        this.height = d;
        this.isTop = true;
    }

    public boolean isTop() {
        return this.isTop;
    }

    public boolean isBottom() {
        return !this.isTop;
    }

    public void setAsTop() {
        this.isTop = true;
    }

    public void setAsBottom() {
        this.isTop = false;
    }

    @Override
    public void drawSelf(GL2 gL2) {
        if (this.fillColour != null) {
            gL2.glBegin(6);
            gL2.glColor4d(this.fillColour[0], this.fillColour[1], this.fillColour[2], this.fillColour[3]);
            for (double[] dArray : this.vertices) {
                gL2.glVertex2dv(dArray, 0);
            }
            gL2.glEnd();
        }
        if (this.lineColour != null) {
            gL2.glBegin(3);
            gL2.glColor4d(this.lineColour[0], this.lineColour[1], this.lineColour[2], this.lineColour[3]);
            for (double[] dArray : this.vertices) {
                gL2.glVertex2dv(dArray, 0);
            }
            gL2.glVertex2dv(this.vertices.get(0), 0);
            gL2.glEnd();
        }
    }

    @Override
    public boolean containsPoint(double[] dArray) {
        double[] dArray2 = this.getGlobalPosition();
        if (dArray2[0] <= dArray[0] && dArray[0] <= dArray2[0] + this.width) {
            if (this.isTop) {
                return dArray[1] >= dArray2[1];
            }
            return dArray[1] <= dArray2[1] + this.height;
        }
        return false;
    }
}

