/*
 * Decompiled with CFR 0.152.
 */
package FlutteryPigeon;

public class MathUtil {
    public static double normaliseAngle(double d) {
        return ((d + 180.0) % 360.0 + 360.0) % 360.0 - 180.0;
    }

    public static double clamp(double d, double d2, double d3) {
        return Math.max(d2, Math.min(d3, d));
    }

    public static double[][] multiply(double[][] dArray, double[][] dArray2) {
        double[][] dArray3 = new double[3][3];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                dArray3[i][j] = 0.0;
                for (int k = 0; k < 3; ++k) {
                    double[] dArray4 = dArray3[i];
                    int n = j;
                    dArray4[n] = dArray4[n] + dArray[i][k] * dArray2[k][j];
                }
            }
        }
        return dArray3;
    }

    public static double[] multiply(double[][] dArray, double[] dArray2) {
        double[] dArray3 = new double[3];
        for (int i = 0; i < 3; ++i) {
            dArray3[i] = 0.0;
            for (int j = 0; j < 3; ++j) {
                int n = i;
                dArray3[n] = dArray3[n] + dArray[i][j] * dArray2[j];
            }
        }
        return dArray3;
    }

    public static double[][] translationMatrix(double[] dArray) {
        return new double[][]{{1.0, 0.0, dArray[0]}, {0.0, 1.0, dArray[1]}, {0.0, 0.0, 1.0}};
    }

    public static double[][] inverseTranslationMatrix(double[] dArray) {
        double[] dArray2 = new double[]{-dArray[0], -dArray[1]};
        return MathUtil.translationMatrix(dArray2);
    }

    public static double[][] rotationMatrix(double d) {
        double d2 = Math.toRadians(MathUtil.normaliseAngle(d));
        double d3 = Math.sin(d2);
        double d4 = Math.cos(d2);
        return new double[][]{{d4, -d3, 0.0}, {d3, d4, 0.0}, {0.0, 0.0, 1.0}};
    }

    public static double[][] inverseRotationMatrix(double d) {
        return MathUtil.rotationMatrix(-d);
    }

    public static double[][] scaleMatrix(double d) {
        return new double[][]{{d, 0.0, 0.0}, {0.0, d, 0.0}, {0.0, 0.0, 1.0}};
    }

    public static double[][] inverseScaleMatrix(double d) {
        return MathUtil.scaleMatrix(1.0 / d);
    }
}

