/*
 * Decompiled with CFR 0.152.
 */
package FlutteryPigeon;

import FlutteryPigeon.GameObject;
import com.jogamp.opengl.GL2;

public class LineGameObject
extends GameObject {
    private double[] vertices;
    private double[] lineColour;

    public LineGameObject(GameObject gameObject, double[] dArray) {
        this(gameObject, 0.0, 0.0, 1.0, 0.0, dArray);
    }

    public LineGameObject(GameObject gameObject, double d, double d2, double d3, double d4, double[] dArray) {
        super(gameObject);
        this.lineColour = dArray;
        this.vertices = new double[]{d, d2, d3, d4};
    }

    public double[] getVertices() {
        return this.vertices;
    }

    public double[] getLineColour() {
        return this.lineColour;
    }

    public void setLineColour(double[] dArray) {
        this.lineColour = dArray;
    }

    @Override
    public void drawSelf(GL2 gL2) {
        if (this.lineColour != null) {
            gL2.glBegin(1);
            gL2.glColor4dv(this.lineColour, 0);
            gL2.glVertex2dv(this.vertices, 0);
            gL2.glVertex2dv(this.vertices, 2);
            gL2.glEnd();
        }
    }

    @Override
    public boolean containsPoint(double[] dArray) {
        double d;
        double d2 = dArray[0];
        double d3 = dArray[1];
        double[] dArray2 = this.getWorldCoordinates(new double[]{this.vertices[0], this.vertices[1]});
        double[] dArray3 = this.getWorldCoordinates(new double[]{this.vertices[2], this.vertices[3]});
        double d4 = dArray2[0];
        double d5 = dArray2[1];
        double d6 = dArray3[0];
        double d7 = dArray3[1];
        if (d2 == d4 && d3 == d5 || d2 == d6 && d3 == d7) {
            return true;
        }
        double d8 = d4 < d6 ? d4 : d6;
        double d9 = d4 < d6 ? d6 : d4;
        double d10 = d5 < d7 ? d5 : d7;
        double d11 = d = d5 < d7 ? d7 : d5;
        if (!(d8 <= d2 && d2 <= d9 || d10 <= d3 && d3 <= d)) {
            return false;
        }
        double d12 = Math.sqrt(Math.pow(d2 - d4, 2.0) + Math.pow(d3 - d5, 2.0));
        double d13 = Math.sqrt(Math.pow(d6 - d2, 2.0) + Math.pow(d7 - d3, 2.0));
        double d14 = Math.sqrt(Math.pow(d6 - d4, 2.0) + Math.pow(d7 - d5, 2.0));
        double d15 = 1.0E-5;
        return Math.abs(d12 + d13 - d14) < d15;
    }
}

