/*
 * Decompiled with CFR 0.152.
 */
package FlutteryPigeon;

import FlutteryPigeon.Coordinates;
import FlutteryPigeon.FlutteryPigeonEngine;
import FlutteryPigeon.GameObject;
import FlutteryPigeon.MathUtil;
import FlutteryPigeon.Pole;
import FlutteryPigeon.WingState;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class GameState {
    private Thread tickThread;
    private FlutteryPigeonEngine engine;
    private Coordinates pigeonCoordinates = new Coordinates(0.0, 0.0);
    private double upwardVelocity;
    private int tickDownForWing;
    private double lastPoleX;
    private JFrame window;

    public GameState(FlutteryPigeonEngine flutteryPigeonEngine) {
        this.engine = flutteryPigeonEngine;
        this.tickDownForWing = 21;
        this.upwardVelocity = 0.0;
        this.tickThread = new Thread(new TickThread(this));
        this.lastPoleX = 0.0;
        this.window = null;
    }

    public void start() {
        this.tickThread.start();
    }

    public void end() {
        if (this.window != null) {
            JOptionPane.showMessageDialog(this.window, "Game over!");
            this.window.dispose();
        }
        System.exit(0);
    }

    public void bounce() {
        this.tickDownForWing = 40;
        this.upwardVelocity = this.upwardVelocity < -0.02 ? 0.15 : (this.upwardVelocity += 0.25);
        this.upwardVelocity = Math.min(this.upwardVelocity, 0.2);
    }

    public void tick() {
        this.pigeonCoordinates.x += 0.1;
        this.pigeonCoordinates.y += this.upwardVelocity;
        this.engine.getPigeon().setPosition(0.0, this.pigeonCoordinates.y);
        this.engine.getPigeonHole().setPosition(this.pigeonCoordinates.x, 0.0);
        this.engine.getPigeon().setRotation(this.getPigeonAngle());
        if (this.tickDownForWing == 0) {
            this.engine.getPigeon().setWingState(WingState.UP);
        } else if (this.tickDownForWing <= 20) {
            this.engine.getPigeon().setWingState(WingState.FLAT);
        } else if (this.tickDownForWing <= 40) {
            this.engine.getPigeon().setWingState(WingState.DOWN);
        }
        if (this.tickDownForWing > 0) {
            --this.tickDownForWing;
        }
        this.upwardVelocity -= 0.005;
        if (this.pigeonCoordinates.y < -10.0) {
            this.end();
        }
        List<GameObject> list = this.engine.collision(new double[]{this.pigeonCoordinates.x, this.pigeonCoordinates.y});
        for (GameObject gameObject : list) {
            if (gameObject.getParent() != this.engine.getPoleParent()) continue;
            this.end();
        }
        if (this.lastPoleX - this.pigeonCoordinates.x < 30.0) {
            new Pole(this.lastPoleX + 7.0);
            this.lastPoleX += 7.0;
        }
    }

    public double getPigeonAngle() {
        double d = this.upwardVelocity * 350.0;
        int n = d < 0.0 ? -1 : 1;
        double d2 = Math.pow(Math.abs(d), 1.3) * (double)n;
        return MathUtil.clamp(d2, -70.0, 70.0);
    }

    public void setWindow(JFrame jFrame) {
        this.window = jFrame;
    }

    public class TickThread
    implements Runnable {
        private GameState gameState;

        public TickThread(GameState gameState2) {
            this.gameState = gameState2;
        }

        @Override
        public void run() {
            while (true) {
                this.gameState.tick();
                try {
                    Thread.sleep(16L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

