/*
 * Decompiled with CFR 0.152.
 */
package FlutteryPigeon;

import FlutteryPigeon.MathUtil;
import com.jogamp.opengl.GL2;
import java.util.ArrayList;
import java.util.List;

public class GameObject {
    public static final List<GameObject> ALL_OBJECTS = new ArrayList<GameObject>();
    public static final GameObject ROOT = new GameObject();
    private GameObject myParent;
    private List<GameObject> myChildren;
    private double myRotation;
    private double myScale;
    private double[] myTranslation;
    private boolean amShowing;

    private GameObject() {
        this.myParent = null;
        this.myChildren = new ArrayList<GameObject>();
        this.myRotation = 0.0;
        this.myScale = 1.0;
        this.myTranslation = new double[2];
        this.myTranslation[0] = 0.0;
        this.myTranslation[1] = 0.0;
        this.amShowing = true;
        ALL_OBJECTS.add(this);
    }

    public GameObject(GameObject gameObject) {
        this.myParent = gameObject;
        this.myChildren = new ArrayList<GameObject>();
        gameObject.myChildren.add(this);
        this.myRotation = 0.0;
        this.myScale = 1.0;
        this.myTranslation = new double[2];
        this.myTranslation[0] = 0.0;
        this.myTranslation[1] = 0.0;
        this.amShowing = true;
        ALL_OBJECTS.add(this);
    }

    public void destroy() {
        ArrayList<GameObject> arrayList = new ArrayList<GameObject>(this.myChildren);
        for (GameObject gameObject : arrayList) {
            gameObject.destroy();
        }
        this.myParent.myChildren.remove(this);
        ALL_OBJECTS.remove(this);
    }

    public GameObject getParent() {
        return this.myParent;
    }

    public List<GameObject> getChildren() {
        return this.myChildren;
    }

    public double getRotation() {
        return this.myRotation;
    }

    public void setRotation(double d) {
        this.myRotation = MathUtil.normaliseAngle(d);
    }

    public void rotate(double d) {
        this.myRotation += d;
        this.myRotation = MathUtil.normaliseAngle(this.myRotation);
    }

    public double getScale() {
        return this.myScale;
    }

    public void setScale(double d) {
        this.myScale = d;
    }

    public void scale(double d) {
        this.myScale *= d;
    }

    public double[] getPosition() {
        double[] dArray = new double[]{this.myTranslation[0], this.myTranslation[1]};
        return dArray;
    }

    public void setPosition(double d, double d2) {
        this.myTranslation[0] = d;
        this.myTranslation[1] = d2;
    }

    public void translate(double d, double d2) {
        this.myTranslation[0] = this.myTranslation[0] + d;
        this.myTranslation[1] = this.myTranslation[1] + d2;
    }

    public boolean isShowing() {
        return this.amShowing;
    }

    public void show(boolean bl) {
        this.amShowing = bl;
    }

    public void update(double d) {
    }

    public void drawSelf(GL2 gL2) {
    }

    public void draw(GL2 gL2) {
        if (!this.amShowing) {
            return;
        }
        gL2.glMatrixMode(5888);
        gL2.glPushMatrix();
        gL2.glTranslated(this.getPosition()[0], this.getPosition()[1], 0.0);
        gL2.glRotated(this.getRotation(), 0.0, 0.0, 1.0);
        gL2.glScaled(this.getScale(), this.getScale(), 1.0);
        this.drawSelf(gL2);
        for (GameObject gameObject : this.myChildren) {
            gameObject.draw(gL2);
        }
        gL2.glPopMatrix();
    }

    public double[] getGlobalPosition() {
        double[][] dArray = this.getGlobalMatrix();
        double[] dArray2 = new double[]{dArray[0][2], dArray[1][2]};
        return dArray2;
    }

    public double getGlobalRotation() {
        double[][] dArray = this.getGlobalMatrix();
        return MathUtil.normaliseAngle(Math.toDegrees(Math.atan2(dArray[1][0], dArray[0][0])));
    }

    public double getGlobalScale() {
        double[][] dArray = this.getGlobalMatrix();
        return Math.sqrt(Math.pow(dArray[0][0], 2.0) + Math.pow(dArray[1][0], 2.0));
    }

    public void setParent(GameObject gameObject) {
        double[][] dArray = this.getGlobalMatrix();
        this.myParent.myChildren.remove(this);
        this.myParent = gameObject;
        this.myParent.myChildren.add(this);
        double[][] dArray2 = MathUtil.inverseScaleMatrix(this.getParent().getGlobalScale());
        dArray2 = MathUtil.multiply(dArray2, MathUtil.inverseRotationMatrix(this.getParent().getGlobalRotation()));
        dArray2 = MathUtil.multiply(dArray2, MathUtil.inverseTranslationMatrix(this.getParent().getGlobalPosition()));
        double[][] dArray3 = MathUtil.multiply(dArray2, dArray);
        this.setPosition(dArray3[0][2], dArray3[1][2]);
        this.setRotation(MathUtil.normaliseAngle(Math.toDegrees(Math.atan2(dArray3[1][0], dArray3[0][0]))));
        this.setScale(Math.sqrt(Math.pow(dArray3[0][0], 2.0) + Math.pow(dArray3[1][0], 2.0)));
    }

    private double[][] getLocalMatrix() {
        double[][] dArray = MathUtil.translationMatrix(this.getPosition());
        dArray = MathUtil.multiply(dArray, MathUtil.rotationMatrix(this.getRotation()));
        dArray = MathUtil.multiply(dArray, MathUtil.scaleMatrix(this.getScale()));
        return dArray;
    }

    private double[][] getGlobalMatrix() {
        if (this.getParent() == null) {
            return this.getLocalMatrix();
        }
        return MathUtil.multiply(this.getParent().getGlobalMatrix(), this.getLocalMatrix());
    }

    public boolean containsPoint(double[] dArray) {
        return false;
    }

    public double[] getWorldCoordinates(double[] dArray) {
        double[] dArray2 = new double[]{dArray[0], dArray[1], 1.0};
        double[] dArray3 = MathUtil.multiply(this.getGlobalMatrix(), dArray2);
        return new double[]{dArray3[0], dArray3[1]};
    }
}

