/*
 * Decompiled with CFR 0.152.
 */
package FlutteryPigeon;

import FlutteryPigeon.Camera;
import FlutteryPigeon.GameObject;
import FlutteryPigeon.Mouse;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import com.jogamp.opengl.GLEventListener;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class GameEngine
implements GLEventListener {
    private Camera myCamera;
    private long myTime;

    public GameEngine(Camera camera) {
        this.myCamera = camera;
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        this.myTime = System.currentTimeMillis();
    }

    public void dispose(GLAutoDrawable gLAutoDrawable) {
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        GL2 gL2 = gLAutoDrawable.getGL().getGL2();
        this.myCamera.reshape(gL2, n, n2, n3, n4);
        Mouse.theMouse.reshape(gL2);
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        GL2 gL2 = gLAutoDrawable.getGL().getGL2();
        this.myCamera.setView(gL2);
        Mouse.theMouse.update(gL2);
        this.update();
        GameObject.ROOT.draw(gL2);
    }

    private void update() {
        long l = System.currentTimeMillis();
        double d = (double)(l - this.myTime) / 1000.0;
        this.myTime = l;
        ArrayList<GameObject> arrayList = new ArrayList<GameObject>(GameObject.ALL_OBJECTS);
        for (GameObject gameObject : arrayList) {
            gameObject.update(d);
        }
    }

    public List<GameObject> collision(double[] dArray) {
        LinkedList<GameObject> linkedList = new LinkedList<GameObject>();
        for (GameObject gameObject : GameObject.ALL_OBJECTS) {
            if (!gameObject.containsPoint(dArray)) continue;
            linkedList.add(gameObject);
        }
        return linkedList;
    }
}

