/*
 * Decompiled with CFR 0.152.
 */
package FlutteryPigeon;

import FlutteryPigeon.GameObject;
import com.jogamp.opengl.GL2;
import java.util.LinkedList;
import java.util.List;

public class CircularGameObject
extends GameObject {
    private List<double[]> vertices;
    private double[] centre;
    private double radius;
    private double[] fillColour;
    private double[] lineColour;

    public CircularGameObject(GameObject gameObject, double[] dArray, double[] dArray2) {
        this(gameObject, 1.0, new double[]{0.0, 0.0}, dArray, dArray2);
    }

    public CircularGameObject(GameObject gameObject, double d, double[] dArray, double[] dArray2) {
        this(gameObject, d, new double[]{0.0, 0.0}, dArray, dArray2);
    }

    public CircularGameObject(GameObject gameObject, double d, double[] dArray, double[] dArray2, double[] dArray3) {
        super(gameObject);
        this.radius = d;
        this.centre = dArray;
        this.fillColour = dArray2;
        this.lineColour = dArray3;
        this.vertices = new LinkedList<double[]>();
        this.calculateVertexLocations();
    }

    private void calculateVertexLocations() {
        for (int i = 0; i < 32; ++i) {
            this.vertices.add(new double[]{this.centre[0] + this.radius * Math.cos((double)(i * 2) * Math.PI / 32.0), this.centre[1] + this.radius * Math.sin((double)(i * 2) * Math.PI / 32.0)});
        }
    }

    public double[] getFillColour() {
        return this.fillColour;
    }

    public void setFillColour(double[] dArray) {
        this.fillColour = dArray;
    }

    public double[] getLineColour() {
        return this.lineColour;
    }

    public void setLineColour(double[] dArray) {
        this.lineColour = dArray;
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double d) {
        this.radius = d;
        this.calculateVertexLocations();
    }

    public double[] getCentre() {
        return this.centre;
    }

    public void setCentre(double[] dArray) {
        this.centre = dArray;
        this.calculateVertexLocations();
    }

    public List<double[]> getVertices() {
        return this.vertices;
    }

    @Override
    public void drawSelf(GL2 gL2) {
        if (this.fillColour != null) {
            gL2.glBegin(6);
            gL2.glColor4dv(this.fillColour, 0);
            gL2.glVertex2dv(this.centre, 0);
            for (double[] dArray : this.vertices) {
                gL2.glVertex2dv(dArray, 0);
            }
            gL2.glVertex2dv(this.vertices.get(0), 0);
            gL2.glEnd();
        }
        if (this.lineColour != null) {
            gL2.glBegin(3);
            gL2.glColor4dv(this.lineColour, 0);
            for (double[] dArray : this.vertices) {
                gL2.glVertex2dv(dArray, 0);
            }
            gL2.glVertex2dv(this.vertices.get(0), 0);
            gL2.glEnd();
        }
    }

    @Override
    public boolean containsPoint(double[] dArray) {
        double d = dArray[0];
        double d2 = dArray[1];
        double[] dArray2 = this.getWorldCoordinates(this.centre);
        double d3 = dArray2[0];
        double d4 = dArray2[1];
        double d5 = this.radius * this.getGlobalScale();
        return Math.pow(d - d3, 2.0) + Math.pow(d2 - d4, 2.0) <= Math.pow(d5, 2.0);
    }
}

