/*
 * Decompiled with CFR 0.152.
 */
package SpaceWars;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.media.opengl.GL2;
import javax.media.opengl.glu.GLU;

public class Mouse
extends MouseAdapter {
    public static final Mouse theMouse = new Mouse();
    private int[] myViewport = new int[4];
    private double[] myProjMatrix = new double[16];
    private double[] myMVMatrix = new double[16];
    private MouseEvent myMouse = null;
    private boolean[] myPressed = new boolean[3];
    private boolean[] myReleased = new boolean[3];
    private boolean[] myWasPressed = new boolean[3];
    private boolean[] myWasReleased = new boolean[3];

    private Mouse() {
    }

    public void reshape(GL2 gL2) {
        gL2.glGetIntegerv(2978, this.myViewport, 0);
        gL2.glGetDoublev(2983, this.myProjMatrix, 0);
    }

    public void update(GL2 gL2) {
        gL2.glGetDoublev(2982, this.myMVMatrix, 0);
        for (int i = 0; i < 3; ++i) {
            this.myWasPressed[i] = this.myPressed[i];
            this.myWasReleased[i] = this.myReleased[i];
            this.myPressed[i] = false;
            this.myReleased[i] = false;
        }
    }

    public double[] getPosition() {
        double[] dArray = new double[3];
        if (this.myMouse != null) {
            int n = this.myMouse.getX();
            int n2 = this.myMouse.getY();
            GLU gLU = new GLU();
            n2 = this.myViewport[3] - n2 - 1;
            gLU.gluUnProject((double)n, (double)n2, 0.0, this.myMVMatrix, 0, this.myProjMatrix, 0, this.myViewport, 0, dArray, 0);
        }
        return dArray;
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.myMouse = mouseEvent;
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.myMouse = mouseEvent;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.myPressed[mouseEvent.getButton() - 1] = true;
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.myReleased[mouseEvent.getButton() - 1] = true;
    }

    public boolean wasPressed(int n) {
        return this.myWasPressed[n - 1];
    }

    public boolean wasReleased(int n) {
        return this.myWasReleased[n - 1];
    }
}

