/*
 * Decompiled with CFR 0.152.
 */
package SpaceWars;

public class MathUtil {
    public static double normaliseAngle(double d) {
        return ((d + 180.0) % 360.0 + 360.0) % 360.0 - 180.0;
    }

    public static double clamp(double d, double d2, double d3) {
        return Math.max(d2, Math.min(d3, d));
    }

    public static double[][] multiply(double[][] dArray, double[][] dArray2) {
        double[][] dArray3 = new double[3][3];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                dArray3[i][j] = 0.0;
                for (int k = 0; k < 3; ++k) {
                    double[] dArray4 = dArray3[i];
                    int n = j;
                    dArray4[n] = dArray4[n] + dArray[i][k] * dArray2[k][j];
                }
            }
        }
        return dArray3;
    }

    public static double[] multiply(double[][] dArray, double[] dArray2) {
        double[] dArray3 = new double[3];
        for (int i = 0; i < 3; ++i) {
            dArray3[i] = 0.0;
            for (int j = 0; j < 3; ++j) {
                int n = i;
                dArray3[n] = dArray3[n] + dArray[i][j] * dArray2[j];
            }
        }
        return dArray3;
    }

    public static double[][] translationMatrix(double[] dArray) {
        double[][] dArrayArray = new double[][]{{1.0, 0.0, dArray[0]}, {0.0, 1.0, dArray[1]}, {0.0, 0.0, 1.0}};
        return dArrayArray;
    }

    public static double[][] rotationMatrix(double d) {
        double[][] dArrayArray = new double[][]{{Math.cos(d * (Math.PI / 180)), -Math.sin(d * (Math.PI / 180)), 0.0}, {Math.sin(d * (Math.PI / 180)), Math.cos(d * (Math.PI / 180)), 0.0}, {0.0, 0.0, 1.0}};
        return dArrayArray;
    }

    public static double[][] scaleMatrix(double d) {
        double[][] dArrayArray = new double[][]{{d, 0.0, 0.0}, {0.0, d, 0.0}, {0.0, 0.0, 1.0}};
        return dArrayArray;
    }
}

