/*
 * Decompiled with CFR 0.152.
 */
package SpaceWars;

import SpaceWars.MathUtil;
import java.util.ArrayList;
import java.util.List;
import javax.media.opengl.GL2;

public class GameObject {
    public static final List<GameObject> ALL_OBJECTS = new ArrayList<GameObject>();
    public static final GameObject ROOT = new GameObject();
    private GameObject myParent;
    private List<GameObject> myChildren;
    private double myRotation;
    private double myScale;
    private double[] myTranslation;
    private boolean amShowing;

    private GameObject() {
        this.myParent = null;
        this.myChildren = new ArrayList<GameObject>();
        this.myRotation = 0.0;
        this.myScale = 1.0;
        this.myTranslation = new double[2];
        this.myTranslation[0] = 0.0;
        this.myTranslation[1] = 0.0;
        this.amShowing = true;
        ALL_OBJECTS.add(this);
    }

    public GameObject(GameObject gameObject) {
        this.myParent = gameObject;
        this.myChildren = new ArrayList<GameObject>();
        gameObject.myChildren.add(this);
        this.myRotation = 0.0;
        this.myScale = 1.0;
        this.myTranslation = new double[2];
        this.myTranslation[0] = 0.0;
        this.myTranslation[1] = 0.0;
        this.amShowing = true;
        ALL_OBJECTS.add(this);
    }

    public void destroy() {
        for (GameObject gameObject : this.myChildren) {
            gameObject.destroy();
        }
        this.myParent.myChildren.remove(this);
        ALL_OBJECTS.remove(this);
    }

    public GameObject getParent() {
        return this.myParent;
    }

    public List<GameObject> getChildren() {
        return this.myChildren;
    }

    public double getRotation() {
        return this.myRotation;
    }

    public void setRotation(double d) {
        this.myRotation = MathUtil.normaliseAngle(d);
    }

    public void rotate(double d) {
        this.myRotation += d;
        this.myRotation = MathUtil.normaliseAngle(this.myRotation);
    }

    public double getScale() {
        return this.myScale;
    }

    public void setScale(double d) {
        this.myScale = d;
    }

    public void scale(double d) {
        this.myScale *= d;
    }

    public double[] getPosition() {
        double[] dArray = new double[]{this.myTranslation[0], this.myTranslation[1]};
        return dArray;
    }

    public void setPosition(double d, double d2) {
        this.myTranslation[0] = d;
        this.myTranslation[1] = d2;
    }

    public void translate(double d, double d2) {
        this.myTranslation[0] = this.myTranslation[0] + d;
        this.myTranslation[1] = this.myTranslation[1] + d2;
    }

    public boolean isShowing() {
        return this.amShowing;
    }

    public void show(boolean bl) {
        this.amShowing = bl;
    }

    public void update(double d) {
    }

    public void drawSelf(GL2 gL2) {
    }

    public void draw(GL2 gL2) {
        if (!this.amShowing) {
            return;
        }
        gL2.glPushMatrix();
        double[] dArray = this.getPosition();
        gL2.glTranslated(dArray[0], dArray[1], 0.0);
        gL2.glRotated(this.getRotation(), 0.0, 0.0, 1.0);
        gL2.glScaled(this.getScale(), this.getScale(), 1.0);
        this.drawSelf(gL2);
        for (GameObject gameObject : this.getChildren()) {
            gameObject.draw(gL2);
        }
        gL2.glPopMatrix();
    }

    public double[] getGlobalPosition() {
        double[] dArray = new double[2];
        if (this.getParent() == null) {
            dArray = this.getPosition();
        } else {
            double[][] dArray2 = this.getModelMatrix();
            dArray[0] = dArray2[0][2];
            dArray[1] = dArray2[1][2];
        }
        return dArray;
    }

    public double getGlobalRotation() {
        double d;
        if (this.getParent() == null) {
            d = this.getRotation();
        } else {
            double d2 = this.getParent().getGlobalRotation();
            double d3 = this.getRotation();
            d = MathUtil.normaliseAngle(d3 + d2);
        }
        return d;
    }

    public double getGlobalScale() {
        double d;
        if (this.getParent() == null) {
            d = this.getScale();
        } else {
            double d2 = this.getParent().getGlobalScale();
            double d3 = this.getScale();
            d = d3 * d2;
        }
        return d;
    }

    public double[][] getModelMatrix() {
        Object object = new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}};
        if (this.getParent() != null) {
            double[][] dArray = MathUtil.translationMatrix(this.getPosition());
            double[][] dArray2 = MathUtil.rotationMatrix(this.getRotation());
            double[][] dArray3 = MathUtil.scaleMatrix(this.getScale());
            double[][] dArray4 = this.getParent().getModelMatrix();
            object = MathUtil.multiply(dArray4, MathUtil.multiply(dArray, MathUtil.multiply(dArray2, dArray3)));
        }
        return object;
    }

    public void setParent(GameObject gameObject) {
        double[] dArray = new double[]{this.getGlobalPosition()[0], this.getGlobalPosition()[1], 1.0};
        double[] dArray2 = MathUtil.multiply(gameObject.invertModel(), dArray);
        double d = this.getGlobalRotation() - gameObject.getGlobalRotation();
        double d2 = this.getGlobalScale() / gameObject.getGlobalScale();
        this.setPosition(dArray2[0], dArray2[1]);
        this.setRotation(d);
        this.setScale(d2);
        this.myParent.myChildren.remove(this);
        this.myParent = gameObject;
        this.myParent.myChildren.add(this);
    }

    public double[][] invertModel() {
        Object object = new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}};
        if (this.getParent() != null) {
            double[][] dArray = this.getParent().invertModel();
            double[][] dArray2 = MathUtil.scaleMatrix(1.0 / this.getScale());
            double[][] dArray3 = MathUtil.rotationMatrix(-this.getRotation());
            double[] dArray4 = new double[]{-this.getPosition()[0], -this.getPosition()[1]};
            double[][] dArray5 = MathUtil.translationMatrix(dArray4);
            object = MathUtil.multiply(dArray2, MathUtil.multiply(dArray3, MathUtil.multiply(dArray5, dArray)));
        }
        return object;
    }

    public void removeObject() {
        this.myParent.myChildren.remove(this);
        ALL_OBJECTS.remove(this);
    }

    public int objectType() {
        return 0;
    }
}

