/*
 * Decompiled with CFR 0.152.
 */
package SpaceWars;

import SpaceWars.DeathStar;
import SpaceWars.GameObject;
import SpaceWars.Laser;
import SpaceWars.LineGameObject;
import SpaceWars.XWing;
import java.util.LinkedList;
import java.util.List;

public class GameModel {
    private XWing xWing = new XWing(GameObject.ROOT);
    private LineGameObject btmBorder;
    private LineGameObject leftBorder;
    private LineGameObject rightBorder;
    private List<Laser> lasers;
    private List<DeathStar> stars;

    public GameModel() {
        this.xWing.setPosition(0.0, -9.25);
        double[] dArray = new double[]{0.0, 0.0, 1.0, 1.0};
        this.btmBorder = new LineGameObject(GameObject.ROOT, -10.5, -8.0, 10.5, -8.0, dArray);
        this.leftBorder = new LineGameObject(GameObject.ROOT, -10.5, -10.0, -10.5, 10.0, dArray);
        this.rightBorder = new LineGameObject(GameObject.ROOT, 10.5, -10.0, 10.5, 10.0, dArray);
        this.lasers = new LinkedList<Laser>();
        this.stars = new LinkedList<DeathStar>();
        this.createStar(-9.0);
    }

    public void shoot() {
        double[] dArray = this.xWing.getGlobalPosition();
        Laser laser = new Laser(GameObject.ROOT);
        laser.setPosition(dArray[0] + 0.7, dArray[1] + 0.5);
        this.lasers.add(laser);
        Laser laser2 = new Laser(GameObject.ROOT);
        laser2.setPosition(dArray[0] - 0.7, dArray[1] + 0.5);
        this.lasers.add(laser2);
    }

    public void createStar(double d) {
        DeathStar deathStar = new DeathStar(GameObject.ROOT, 0.5);
        deathStar.setPosition(d, 10.0);
        this.stars.add(deathStar);
    }

    public void xMoveLeft() {
        if (this.xWing.getGlobalPosition()[0] >= -9.5) {
            this.xWing.translate(-0.5, 0.0);
        } else {
            this.xWing.translate(0.5, 0.0);
        }
    }

    public void xMoveRight() {
        if (this.xWing.getGlobalPosition()[0] <= 9.5) {
            this.xWing.translate(0.5, 0.0);
        } else {
            this.xWing.translate(-0.5, 0.0);
        }
    }

    public void checkLaserBounds() {
        LinkedList<Laser> linkedList = new LinkedList<Laser>();
        for (Laser laser : this.lasers) {
            if (!(laser.getGlobalPosition()[1] >= 9.5)) continue;
            laser.removeObject();
            linkedList.add(laser);
        }
        for (Laser laser : linkedList) {
            this.lasers.remove(laser);
        }
    }

    public boolean checkStarBounds() {
        for (DeathStar deathStar : this.stars) {
            if (!(deathStar.getGlobalPosition()[1] - deathStar.getRadius() < -8.0)) continue;
            return true;
        }
        return false;
    }

    public int checkCollision() {
        LinkedList<Laser> linkedList = new LinkedList<Laser>();
        LinkedList<DeathStar> linkedList2 = new LinkedList<DeathStar>();
        int n = 0;
        for (DeathStar gameObject : this.stars) {
            for (Laser laser : this.lasers) {
                double d = gameObject.getRadius();
                double[] dArray = gameObject.getGlobalPosition();
                double d2 = Math.sqrt(Math.pow(laser.getGlobalPosition()[1] + 0.5 - dArray[1], 2.0) + Math.pow(laser.getGlobalPosition()[0] - dArray[0], 2.0));
                if (!(d2 <= d)) continue;
                gameObject.removeObject();
                laser.removeObject();
                linkedList.add(laser);
                linkedList2.add(gameObject);
                ++n;
            }
        }
        for (Laser laser : linkedList) {
            this.lasers.remove(laser);
        }
        for (DeathStar deathStar : linkedList2) {
            this.stars.remove(deathStar);
        }
        return n;
    }
}

