/*
 * Decompiled with CFR 0.152.
 */
package SpaceWars;

import SpaceWars.Camera;
import SpaceWars.CircularGameObject;
import SpaceWars.GameObject;
import SpaceWars.LineGameObject;
import SpaceWars.MathUtil;
import SpaceWars.Mouse;
import SpaceWars.PolygonalGameObject;
import java.util.ArrayList;
import java.util.List;
import javax.media.opengl.GL2;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLEventListener;

public class GameEngine
implements GLEventListener {
    private Camera myCamera;
    private long myTime;

    public GameEngine(Camera camera) {
        this.myCamera = camera;
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        this.myTime = System.currentTimeMillis();
    }

    public void dispose(GLAutoDrawable gLAutoDrawable) {
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        GL2 gL2 = gLAutoDrawable.getGL().getGL2();
        this.myCamera.reshape(gL2, n, n2, n3, n4);
        Mouse.theMouse.reshape(gL2);
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        GL2 gL2 = gLAutoDrawable.getGL().getGL2();
        this.myCamera.setView(gL2);
        Mouse.theMouse.update(gL2);
        this.update();
        GameObject.ROOT.draw(gL2);
    }

    private void update() {
        long l = System.currentTimeMillis();
        double d = (double)(l - this.myTime) / 1000.0;
        this.myTime = l;
        ArrayList<GameObject> arrayList = new ArrayList<GameObject>(GameObject.ALL_OBJECTS);
        for (GameObject gameObject : arrayList) {
            gameObject.update(d);
        }
    }

    public List<GameObject> collision(double[] dArray) {
        double[] dArray2;
        ArrayList<GameObject> arrayList = new ArrayList<GameObject>(GameObject.ALL_OBJECTS);
        ArrayList<PolygonalGameObject> arrayList2 = new ArrayList<PolygonalGameObject>();
        ArrayList<CircularGameObject> arrayList3 = new ArrayList<CircularGameObject>();
        ArrayList<LineGameObject> arrayList4 = new ArrayList<LineGameObject>();
        ArrayList<GameObject> arrayList5 = new ArrayList<GameObject>();
        for (GameObject gameObject : arrayList) {
            int n = gameObject.objectType();
            if (n == 0) continue;
            if (n == 1) {
                arrayList2.add((PolygonalGameObject)gameObject);
                continue;
            }
            if (n == 2) {
                arrayList3.add((CircularGameObject)gameObject);
                continue;
            }
            if (n != 3) continue;
            arrayList4.add((LineGameObject)gameObject);
        }
        for (PolygonalGameObject polygonalGameObject : arrayList2) {
            double[] dArray3 = polygonalGameObject.getPoints();
            dArray2 = new double[]{dArray[0], dArray[1], 1.0};
            double[] dArray4 = MathUtil.multiply(polygonalGameObject.invertModel(), dArray2);
            dArray4[0] = (double)Math.round(dArray4[0] * 1000.0) / 1000.0;
            dArray4[1] = (double)Math.round(dArray4[1] * 1000.0) / 1000.0;
            int n = 0;
            for (int i = 0; i < dArray3.length; i += 2) {
                double d;
                double[] dArray5;
                double[] dArray6;
                double[] dArray7 = new double[]{dArray3[i], dArray3[i + 1]};
                double[] dArray8 = new double[]{0.0, 0.0};
                if (i + 2 == dArray3.length) {
                    dArray8[0] = dArray3[0];
                    dArray8[1] = dArray3[1];
                } else {
                    dArray8[0] = dArray3[i + 2];
                    dArray8[1] = dArray3[i + 3];
                }
                if (dArray7[1] > dArray8[1]) {
                    dArray6 = dArray7;
                    dArray5 = dArray8;
                } else if (dArray7[1] < dArray8[1]) {
                    dArray6 = dArray8;
                    dArray5 = dArray7;
                } else if (dArray7[0] > dArray8[0]) {
                    dArray5 = dArray7;
                    dArray6 = dArray8;
                } else {
                    dArray5 = dArray8;
                    dArray6 = dArray7;
                }
                if (dArray6[1] == dArray5[1]) {
                    if (dArray4[1] != dArray5[1] || !(dArray4[0] <= dArray5[0]) || dArray4[0] == dArray6[0]) continue;
                    ++n;
                    continue;
                }
                if (dArray4[1] >= dArray6[1] || dArray4[1] < dArray5[1] || !(dArray4[0] <= (d = dArray6[0] < dArray5[0] ? dArray5[0] : dArray6[0]))) continue;
                ++n;
            }
            if (n % 2 != 1) continue;
            arrayList5.add(polygonalGameObject);
        }
        for (CircularGameObject circularGameObject : arrayList3) {
            double[] dArray9 = new double[]{dArray[0], dArray[1], 1.0};
            dArray2 = MathUtil.multiply(circularGameObject.invertModel(), dArray9);
            double d = circularGameObject.getRadius();
            double[] dArray10 = new double[]{0.0, 0.0};
            double[] dArray11 = dArray10;
            double d2 = Math.sqrt(Math.pow(dArray2[1] - dArray11[1], 2.0) + Math.pow(dArray2[0] - dArray11[0], 2.0));
            if (!(d2 <= d)) continue;
            arrayList5.add(circularGameObject);
        }
        for (LineGameObject lineGameObject : arrayList4) {
            double[] dArray12 = new double[]{dArray[0], dArray[1], 1.0};
            dArray2 = MathUtil.multiply(lineGameObject.invertModel(), dArray12);
            dArray2[0] = (double)Math.round(dArray2[0] * 1000.0) / 1000.0;
            dArray2[1] = (double)Math.round(dArray2[1] * 1000.0) / 1000.0;
            double d = lineGameObject.getX1();
            double d3 = lineGameObject.getY1();
            double d4 = lineGameObject.getX2();
            double d5 = dArray2[1] - d3;
            double d6 = lineGameObject.getY2();
            double d7 = (d6 - d3) / (d4 - d);
            double d8 = d7 * (dArray2[0] - d);
            if (d5 != d8) continue;
            arrayList5.add(lineGameObject);
        }
        return arrayList5;
    }
}

