/*
 * Decompiled with CFR 0.152.
 */
package SpaceWars;

import SpaceWars.Camera;
import SpaceWars.GameController;
import SpaceWars.GameModel;
import SpaceWars.GameObject;
import SpaceWars.Mouse;
import com.jogamp.opengl.util.FPSAnimator;
import java.awt.Component;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import javax.media.opengl.GL2;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLProfile;
import javax.media.opengl.awt.GLJPanel;
import javax.swing.JFrame;

public class Game
implements GLEventListener {
    private Camera myCamera;
    private long myTime;
    private double dx;
    private GameModel model;
    private double timeSinceSpawn;
    private double spawningTime;
    private double numDestroyed;
    private double randomAngle;

    public Game(Camera camera, GameModel gameModel) {
        this.myCamera = camera;
        this.model = gameModel;
        this.spawningTime = 2.0;
        this.numDestroyed = 0.0;
        this.timeSinceSpawn = 0.0;
        this.randomAngle = 0.0;
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        this.myTime = System.currentTimeMillis();
    }

    public void dispose(GLAutoDrawable gLAutoDrawable) {
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        GL2 gL2 = gLAutoDrawable.getGL().getGL2();
        this.myCamera.reshape(gL2, n, n2, n3, n4);
        Mouse.theMouse.reshape(gL2);
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        GL2 gL2 = gLAutoDrawable.getGL().getGL2();
        this.myCamera.setView(gL2);
        Mouse.theMouse.update(gL2);
        this.update();
        GameObject.ROOT.draw(gL2);
    }

    private void update() {
        long l = System.currentTimeMillis();
        double d = (double)(l - this.myTime) / 1000.0;
        this.myTime = l;
        this.timeSinceSpawn += d;
        this.randomAngle = this.randomAngle >= 360.0 ? 0.0 : (this.randomAngle += 1.0);
        boolean bl = this.model.checkStarBounds();
        if (bl) {
            return;
        }
        this.model.checkLaserBounds();
        this.numDestroyed += (double)this.model.checkCollision();
        if (this.numDestroyed >= 6.0 && this.spawningTime >= 0.75) {
            this.spawningTime -= 0.05;
        }
        if (this.timeSinceSpawn > this.spawningTime) {
            double d2 = 10.0 * Math.sin(this.randomAngle * (Math.PI / 180));
            this.model.createStar(d2);
            this.timeSinceSpawn = 0.0;
        }
        ArrayList<GameObject> arrayList = new ArrayList<GameObject>(GameObject.ALL_OBJECTS);
        for (GameObject gameObject : arrayList) {
            gameObject.update(this.dx);
        }
    }

    public static void main(String[] stringArray) {
        GLProfile gLProfile = GLProfile.getDefault();
        GLCapabilities gLCapabilities = new GLCapabilities(gLProfile);
        GLJPanel gLJPanel = new GLJPanel((GLCapabilitiesImmutable)gLCapabilities);
        Camera camera = new Camera(GameObject.ROOT);
        camera.scale(10.0);
        GameModel gameModel = new GameModel();
        Game game = new Game(camera, gameModel);
        gLJPanel.addGLEventListener((GLEventListener)game);
        GameController gameController = new GameController(gameModel);
        gLJPanel.addKeyListener((KeyListener)gameController);
        FPSAnimator fPSAnimator = new FPSAnimator(60);
        fPSAnimator.add((GLAutoDrawable)gLJPanel);
        fPSAnimator.start();
        JFrame jFrame = new JFrame("Space Wars");
        jFrame.add((Component)gLJPanel);
        jFrame.setSize(1000, 720);
        jFrame.setVisible(true);
        jFrame.setDefaultCloseOperation(3);
    }
}

