/*
 * Decompiled with CFR 0.152.
 */
package SpaceWars;

import SpaceWars.CircularGameObject;
import SpaceWars.GameObject;
import SpaceWars.LineGameObject;
import javax.media.opengl.GL2;

public class DeathStar
extends GameObject {
    private double myRadius;
    private double[] myPoints;
    private double[] myFillColour;
    private double[] myLineColour;
    private final double numSide = 32.0;
    private final double circleAngle = 360.0;

    public DeathStar(GameObject gameObject, double d) {
        super(gameObject);
        this.myRadius = d;
        this.myPoints = new double[64];
        this.myFillColour = new double[]{0.5, 0.5, 0.5, 1.0};
        this.myLineColour = new double[]{0.0, 0.0, 0.0, 1.0};
        double d2 = 0.0;
        int n = 0;
        while ((double)n < 64.0) {
            this.myPoints[n] = this.myRadius * Math.cos(d2 * (Math.PI / 180));
            this.myPoints[n + 1] = this.myRadius * Math.sin(d2 * (Math.PI / 180));
            d2 += 11.25;
            n += 2;
        }
        this.createChildren();
    }

    public double getRadius() {
        return this.myRadius;
    }

    public void setRadius(double d) {
        this.myRadius = d;
    }

    public double[] getPoints() {
        return this.myPoints;
    }

    public void setPoints(double[] dArray) {
        this.myPoints = dArray;
    }

    public double[] getFillColour() {
        return this.myFillColour;
    }

    public void setFillColour(double[] dArray) {
        this.myFillColour = dArray;
    }

    public double[] getLineColour() {
        return this.myLineColour;
    }

    public void setLineColour(double[] dArray) {
        this.myLineColour = dArray;
    }

    @Override
    public void drawSelf(GL2 gL2) {
        int n;
        if (this.myFillColour != null) {
            gL2.glPolygonMode(1032, 6914);
            gL2.glColor4d(this.myFillColour[0], this.myFillColour[1], this.myFillColour[2], this.myFillColour[3]);
            gL2.glBegin(9);
            for (n = 0; n < this.myPoints.length; n += 2) {
                gL2.glVertex2d(this.myPoints[n], this.myPoints[n + 1]);
            }
            gL2.glEnd();
        }
        if (this.myLineColour != null) {
            gL2.glPolygonMode(1032, 6913);
            gL2.glColor4d(this.myLineColour[0], this.myLineColour[1], this.myLineColour[2], this.myLineColour[3]);
            gL2.glBegin(9);
            for (n = 0; n < this.myPoints.length; n += 2) {
                gL2.glVertex2d(this.myPoints[n], this.myPoints[n + 1]);
            }
            gL2.glEnd();
        }
        gL2.glPolygonMode(1032, 6914);
    }

    @Override
    public int objectType() {
        return 5;
    }

    @Override
    public void update(double d) {
        this.translate(0.0, -0.02);
    }

    private void createChildren() {
        double d = -this.getRadius();
        double d2 = 0.0;
        double d3 = this.getRadius();
        double d4 = 0.0;
        double[] dArray = new double[]{0.0, 0.0, 0.0, 1.0};
        LineGameObject lineGameObject = new LineGameObject(this, d, d2, d3, d4, dArray);
        double d5 = this.getRadius() / 5.0 * 1.5;
        double d6 = this.getRadius() / 5.0 * 2.0;
        double[] dArray2 = new double[]{0.3, 0.3, 0.3, 1.0};
        CircularGameObject circularGameObject = new CircularGameObject(this, d5, dArray2, dArray);
        circularGameObject.setPosition(d6, d6);
    }
}

