/*
 * Decompiled with CFR 0.152.
 */
package SpaceWars;

import SpaceWars.GameObject;
import javax.media.opengl.GL2;

public class CircularGameObject
extends GameObject {
    private double myRadius;
    private double[] myPoints;
    private double[] myFillColour;
    private double[] myLineColour;
    private final double numSide = 32.0;
    private final double circleAngle = 360.0;

    public CircularGameObject(GameObject gameObject, double[] dArray, double[] dArray2) {
        super(gameObject);
        this.myRadius = 1.0;
        this.myPoints = new double[64];
        this.myFillColour = dArray;
        this.myLineColour = dArray2;
        double d = 0.0;
        int n = 0;
        while ((double)n < 64.0) {
            this.myPoints[n] = this.myRadius * Math.cos(d * (Math.PI / 180));
            this.myPoints[n + 1] = this.myRadius * Math.sin(d * (Math.PI / 180));
            d += 11.25;
            n += 2;
        }
    }

    public CircularGameObject(GameObject gameObject, double d, double[] dArray, double[] dArray2) {
        super(gameObject);
        this.myRadius = d;
        this.myPoints = new double[64];
        this.myFillColour = dArray;
        this.myLineColour = dArray2;
        double d2 = 0.0;
        int n = 0;
        while ((double)n < 64.0) {
            this.myPoints[n] = this.myRadius * Math.cos(d2 * (Math.PI / 180));
            this.myPoints[n + 1] = this.myRadius * Math.sin(d2 * (Math.PI / 180));
            d2 += 11.25;
            n += 2;
        }
    }

    public double getRadius() {
        return this.myRadius;
    }

    public void setRadius(double d) {
        this.myRadius = d;
    }

    public double[] getPoints() {
        return this.myPoints;
    }

    public void setPoints(double[] dArray) {
        this.myPoints = dArray;
    }

    public double[] getFillColour() {
        return this.myFillColour;
    }

    public void setFillColour(double[] dArray) {
        this.myFillColour = dArray;
    }

    public double[] getLineColour() {
        return this.myLineColour;
    }

    public void setLineColour(double[] dArray) {
        this.myLineColour = dArray;
    }

    @Override
    public void drawSelf(GL2 gL2) {
        int n;
        if (this.myFillColour != null) {
            gL2.glPolygonMode(1032, 6914);
            gL2.glColor4d(this.myFillColour[0], this.myFillColour[1], this.myFillColour[2], this.myFillColour[3]);
            gL2.glBegin(9);
            for (n = 0; n < this.myPoints.length; n += 2) {
                gL2.glVertex2d(this.myPoints[n], this.myPoints[n + 1]);
            }
            gL2.glEnd();
        }
        if (this.myLineColour != null) {
            gL2.glPolygonMode(1032, 6913);
            gL2.glColor4d(this.myLineColour[0], this.myLineColour[1], this.myLineColour[2], this.myLineColour[3]);
            gL2.glBegin(9);
            for (n = 0; n < this.myPoints.length; n += 2) {
                gL2.glVertex2d(this.myPoints[n], this.myPoints[n + 1]);
            }
            gL2.glEnd();
        }
        gL2.glPolygonMode(1032, 6914);
    }

    @Override
    public int objectType() {
        return 2;
    }
}

