
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_LINE 1024

struct node {
	int value;
	struct node *next;
};

int listGetMax(struct node *list);
bool listGetMaxV2(struct node *list, int *maxValue);

struct node *readList(void);
struct node *newNode(int value);
void printList(struct node *list);
void freeList(struct node *list);

int main(void) {
	printf("Enter list values: ");
	struct node *list = readList();

	printf("List: ");
	printList(list);

	printf("Enter index: ");
	int index = 0;
	scanf("%d", &index);

	int value = listGetIndex(list, index);
	printf("Index %d is %d\n", index, value);

	freeList(list);
}

////////////////////////////////////////////////////////////////////////

int listGetMax(struct node *list) {
    // Assume at least one value in the list
    assert(list);

    if(list->next == NULL) {
        return list->value;
    }

    int max_of_rest_of_list = listGetMax(list->next);
    int max_of_whole_list_including_me = max_of_rest_of_list;

    if (list->value > max_of_whole_list_including_me) {
        max_of_whole_list_including_me = list->value;
    }

    return max_of_whole_list_including_me;

}

// return true if there exists a max value, otherwise return false.
// the max value, if the function returns true, should be stored in maxValue
bool listGetMaxV2(struct node *list, int *maxValue) {
    return false;
}

////////////////////////////////////////////////////////////////////////

struct node *readList(void) {
	char line[MAX_LINE];
	fgets(line, MAX_LINE, stdin);

	struct node *list = NULL;
	struct node *curr = NULL;

	char *token = strtok(line, " \n\t");
	while (token != NULL) {
		int value;
		if (sscanf(token, "%d", &value) == 1) {
			struct node *node = newNode(value);
			if (list == NULL) {
				list = node;
			} else {
				curr->next = node;
			}
			curr = node;
		}

		token = strtok(NULL, " \n\t");
	}

	return list;
}

struct node *newNode(int value) {
	struct node *n = malloc(sizeof(*n));
	if (n == NULL) {
		fprintf(stderr, "error: out of memory\n");
		exit(EXIT_FAILURE);
	}

	n->value = value;
	n->next = NULL;
	return n;
}

void printList(struct node *list) {
	printf("[");
	for (struct node *curr = list; curr != NULL; curr = curr->next) {
		printf("%d", curr->value);
		if (curr->next != NULL) {
			printf(", ");
		}
	}
	printf("]\n");
}

void freeList(struct node *list) {
	struct node *curr = list;
	while (curr != NULL) {
		struct node *temp = curr;
		curr = curr->next;
		free(temp);
	}
}
