# Get Set

Hello and welcome to COMP1010! This is your first lab exercise, and you're
reading the README file. In most computer programming projects, there will be
a README which has information about the code. You should always read it to
make sure you understand what you're looking at. For COMP1010, we'll put all
the instructions for your labs into this file, so make sure you always check
it!

## Context

Getting ready to program can sound a little daunting, but taking the time to do
it properly is very worthwhile. Let's take the time to make sure you're ready
to jump into COMP1010.

## Preparing for COMP1010

If you've got any questions outside of class time, the [Discourse forum](https://discourse01.cse.unsw.edu.au/26T1/COMP1010/) is the
place to go!

Make sure to introduce yourself and say hi in the welcome thread!

## Getting set up

Let's start the process of setting yourself up for COMP1010. It's highly
recommended that you try this during your lab time, to ensure that a tutor is
available to assist if anything goes wrong.

You may want to watch the video walkthroughs for this lab exercise if you'd
like to see a demonstration.

Note that these videos use an outdated installation command. Please make sure
you copy our (much simpler) new command below.

* [Get Set for COMP1010 - MacOS](https://youtu.be/2-7fXe5MdP4)
* [Get Set for COMP1010 - Windows](https://youtu.be/IQ7lqtwkC_c)

### 1. Installing software

Please install all of the following software:

* [VS Code](https://code.visualstudio.com/)

* [Python](https://www.python.org/downloads/) (when running the installer, make
  sure you select the option that adds Python to the `PATH` variable)

* [UV](https://docs.astral.sh/uv/getting-started/installation/)

### 2. Testing installed software

Open up a terminal and run each of these commands one-by-one. If any cause
errors, you should grab your tutor for help.

```sh
python -c "print('Hello, world!')"
```

```sh
uvx cowsay -t 'Hello, world!'
```

### 3. Opening VS Code (the right way)

Getting work done is much easier if VS Code can see the full context of your
work.

1. Open VS Code
2. From the `File` menu, choose to `Open folder`
3. Navigate to, then highlight the folder that contains this file (it is
   probably called `get_set`)
4. Choose to open it.
5. You will be prompted to install the recommended extensions. Install them.

If you've done this correctly, you should see this file (`README.md`) as well
a program `get_set.py` and some other files in the "Files panel" on the
left-hand side of the screen.

### 4. Checking your setup

Now let's make sure you've set up everything correctly and configure VS Code.

1. Click on `get_set.py` to open it. Don't worry if you don't understand the
   code.
2. Click on the play button in the top right of VS Code's tab bar.
3. Watch as VS Code opens a terminal and runs the program.
4. If you have existing VS Code settings, it will ask if it's ok to overwrite
   them. If you choose yes, a backup of your old settings will be created.
4. Read the output. If it worked correctly, you'll get a message telling you
   so. If not, try following the suggested fixes. If all else false, you can
   always post on the forum or ask your tutor.

## Marking

1 mark available.

## Submission

Now it's time to submit your work. Grab your tutor's attention, and they'll
come over and give you a mark.
